<?php /* public/index.php */

declare(strict_types=1);

/* ====== Sesión "fake" con JSON (seed si no existe) ====== */
$userFile = __DIR__ . '/user.json';
if (!file_exists($userFile)) {
	$seed = [
		"id" => "u_demo_001",
		"name" => "Carlos Mejía",
		"email" => "carlos.mejia@example.com",
		"balance" => 0,
		"currency" => "HNL",
		"billing" => [
			"address" => "Col. Las Colinas, Casa 12",
			"country" => "HN",
			"state" => "FM",
			"city" => "Tegucigalpa",
			"phone" => "+504 9999-9999"
		],
		"session" => [
			"logged_in" => true,
			"created_at" => date('c')
		]
	];
	file_put_contents($userFile, json_encode($seed, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));
}
$user = json_decode(file_get_contents($userFile), true);
if (!is_array($user)) {
	$user = ["name" => "Usuario", "email" => "", "currency" => "HNL", "billing" => []];
}

/* ====== Config del widget / Next.js (ajusta si cambias el host) ====== */

$NEXT_BASE       = 'https://api.bmticket.com';
$CHECKOUT_SCRIPT = $NEXT_BASE . '/bmt-checkout.js';
?>
<!doctype html>
<html lang="es">

<head>
	<meta charset="utf-8" />
	<title>Recarga Hondubet</title>
	<meta name="viewport" content="width=device-width, initial-scale=1" />
	<link rel="shortcut icon" href="https://bmticket.com/wp-content/uploads/2023/07/dark_Mesa-de-trabajo-1.ico" type="image/x-icon">
	<link rel="apple-touch-icon" href="https://bmticket.com/wp-content/uploads/2023/07/dark-02.ico">
	<meta name="description" content="En BMTicket Honduras, somos la mejor opción para la venta de boletos o tickets para eventos, conciertoSs y espectáculos. Garantizamos innovación y facilidad en la compra de tickets con un sistema innovador, respaldado por nuestra experiencia.">
	<meta property="og:image" content="https://bmticket.com/wp-content/uploads/2024/09/430652944_784461773706126_7709567963859532521_n.jpg">
	<meta property="og:description" content="Somos una empresa comprometida con la calidad y calidez de su servicio, entregados al 100% para lograr sus objetivos. Actuando con transparencia y con fuertes valores que engrandecen su desempeño, con un sistema de Tickets Innovador. Garantizando a sus usuarios el mejor contenido, respaldados en su gran experiencia y conocimiento en la industria. Pionera en Honduras en ventas por Facebook, ofreciendo facilidad y nuevos métodos de venta de boletos.">

	<style>
		:root {
			--bg: #0b1220;
			--card: #111827;
			--line: #1f2937;
			--muted: #9fb0d2;
			--text: #fff;
			--accent: #1ad1a5;
			--accentText: #041421;
			--danger: #ff6b6b;
		}

		* {
			box-sizing: border-box
		}

		body {
			font-family: system-ui, -apple-system, Segoe UI, Roboto, Arial, sans-serif;
			background: var(--bg);
			color: var(--text);
			margin: 0;
			padding: 24px;
		}

		.wrap {
			max-width: 840px;
			margin: 0 auto;
		}

		.card {
			background: var(--card);
			border: 1px solid #222a3a;
			border-radius: 14px;
			padding: 16px;
		}

		.row {
			display: flex;
			gap: 12px;
			align-items: center;
			flex-wrap: wrap
		}

		.grow {
			flex: 1
		}

		.btn {
			display: inline-flex;
			align-items: center;
			gap: 8px;
			padding: 12px 16px;
			border-radius: 12px;
			background: #111827;
			color: #fff;
			border: 1px solid var(--line);
			cursor: pointer
		}

		.btn img {
			height: 22px
		}

		.btnPrimary {
			background: var(--accent);
			color: var(--accentText);
			border: 0;
			font-weight: 800
		}

		.btn[disabled] {
			opacity: .6;
			cursor: default
		}

		.muted {
			color: var(--muted)
		}

		h1 {
			margin: 0 0 12px
		}

		.grid2 {
			display: grid;
			grid-template-columns: 1fr 1fr;
			gap: 16px
		}

		@media (max-width:640px) {
			.grid2 {
				grid-template-columns: 1fr
			}
		}

		.label {
			font-size: 12px;
			opacity: .85
		}

		.val {
			font-weight: 700
		}

		/* ===== Modal depósito ===== */
		.modalBack {
			position: fixed;
			inset: 0;
			background: rgba(0, 0, 0, .55);
			display: none;
			align-items: center;
			justify-content: center;
			padding: 16px
		}

		.modal {
			width: min(520px, 95vw);
			background: #0f1628;
			border: 1px solid #243049;
			border-radius: 14px;
			box-shadow: 0 14px 60px rgba(0, 0, 0, .45)
		}

		.modal header {
			display: flex;
			align-items: center;
			justify-content: space-between;
			padding: 14px 16px;
			border-bottom: 1px solid #22304a
		}

		.modal h3 {
			margin: 0;
			font-size: 16px
		}

		.x {
			background: none;
			border: 0;
			color: #9db0d8;
			font-size: 20px;
			cursor: pointer
		}

		.modal .body {
			padding: 16px
		}

		.hint {
			font-size: 12px;
			color: #9db0d8
		}

		.rowBtns {
			display: flex;
			gap: 8px;
			flex-wrap: wrap;
			margin: 10px 0 6px
		}

		.chip {
			padding: 10px 12px;
			border-radius: 10px;
			background: #111d33;
			border: 1px solid #21304d;
			color: #ffffff;
			cursor: pointer
		}

		.chip.active {
			outline: 2px solid #2ea3ff;
			border-color: #2ea3ff
		}

		.inp {
			width: 100%;
			padding: 12px;
			border-radius: 10px;
			border: 1px solid #21304d;
			background: #0f1429;
			color: #fff;
			outline: none
		}

		.inp[aria-invalid="true"] {
			border-color: var(--danger)
		}

		.total {
			display: flex;
			align-items: center;
			justify-content: space-between;
			padding: 10px 12px;
			border-radius: 10px;
			background: #0f1429;
			border: 1px solid #21304d;
			margin-top: 8px
		}

		.footer {
			padding: 14px 16px;
			border-top: 1px solid #22304a;
			display: flex;
			gap: 10px;
			justify-content: flex-end
		}

		.brandTop {
			display: flex;
			align-items: center;
			gap: 10px
		}

		.brandTop img {
			height: 22px
		}

		.sr-only {
			position: absolute;
			width: 1px;
			height: 1px;
			padding: 0;
			margin: -1px;
			overflow: hidden;
			clip: rect(0, 0, 0, 0);
			white-space: nowrap;
			border: 0
		}

		.status {
			min-height: 1.5em
		}
	</style>
</head>

<body>
	<div class="wrap">
		<div class="row" style="justify-content:space-between;margin-bottom:14px">
			<div class="brandTop">
				<img src="https://hondubet.com/_next/image?url=%2F_next%2Fstatic%2Fmedia%2Fhondubetlogo.09a0c6cc.png&w=256&q=75&dpl=dpl_CW7wx1wEN6w3ychsmQQhgkaupNKR" alt="Hondubet" />
				<span class="muted">Sesión simulada</span>
			</div>
			<button id="editUserBtn" class="btn" title="Editar usuario" aria-haspopup="dialog" aria-controls="editBackdrop">✎ Editar</button>
		</div>

		<div class="card" style="margin-bottom:16px">
			<div class="grid2">
				<div>
					<div class="label">Usuario</div>
					<div class="val"><?= htmlspecialchars($user['name'] ?? '') ?></div>
					<div class="muted" style="font-size:12px"><?= htmlspecialchars($user['email'] ?? '') ?></div>
				</div>
				<div>
					<div class="label">Moneda</div>
					<div class="val"><?= htmlspecialchars($user['currency'] ?? 'HNL') ?></div>
					<div class="label" style="margin-top:8px">Billing (para gateway):</div>
					<div class="muted" style="font-size:12px">
						<?php
						$b = $user['billing'] ?? [];
						echo htmlspecialchars(($b['address'] ?? '') . ', ' . ($b['city'] ?? '') . ', ' . ($b['state'] ?? '') . ' · ' . ($b['phone'] ?? ''));
						?>
					</div>
				</div>
			</div>
		</div>

		<h1>Depositar</h1>
		<button id="btn-deposito" class="btn btnPrimary" aria-haspopup="dialog" aria-controls="depBackdrop">
			<!-- <img src="https://bmticket.com/wp-content/uploads/2024/08/BMT_LOGO_2024-blanco-02.png" alt="" aria-hidden="true"> -->
			<span>Recargar con BMT</span>
		</button>
		<p id="status" class="muted status" role="status" aria-live="polite"></p>
	</div>

	<!-- Modal de monto -->
	<div id="depBackdrop" class="modalBack" role="dialog" aria-modal="true" aria-labelledby="depTitle">
		<div class="modal" role="document">
			<header>
				<button id="depBack" class="x" title="Volver" aria-label="Volver">←</button>
				<h3 id="depTitle">Depósito con Tarjeta</h3>
				<button id="depClose" class="x" title="Cerrar" aria-label="Cerrar">×</button>
			</header>
			<div class="body">
				<div class="hint">Min: L25 &nbsp;&nbsp; Max: L12,500 &nbsp;&nbsp; <span class="muted">Acreditación inmediata</span></div>

				<div class="row" style="gap:10px; margin-top:10px">
					<img src="https://upload.wikimedia.org/wikipedia/commons/5/5e/Visa_Inc._logo.svg" alt="Visa" style="height:15px;opacity:.9">
					<img src="https://upload.wikimedia.org/wikipedia/commons/2/2a/Mastercard-logo.svg" alt="Mastercard" style="height:26px;opacity:.9">
				</div>

				<div style="margin-top:14px">
					<div class="label">Código promocional</div>
					<div class="rowBtns" id="promoRow">
						<button class="chip" data-val="250" type="button" aria-pressed="false">L250</button>
						<button class="chip" data-val="500" type="button" aria-pressed="false">L500</button>
						<button class="chip" data-val="1000" type="button" aria-pressed="false">L1000</button>
						<button class="chip" id="chipOtro" type="button" aria-pressed="false">Otro valor</button>
					</div>

					<label class="label" for="inpMonto" style="display:block;margin-top:10px">Monto de depósito</label>
					<input id="inpMonto" class="inp" inputmode="decimal" placeholder="Ej: 500" aria-invalid="false" autocomplete="off" />

					<div class="total" style="margin-top:10px">
						<span>Total</span>
						<strong id="totalLabel">L 0</strong>
					</div>
				</div>
			</div>
			<div class="footer">
				<button id="depConfirm" class="btn btnPrimary" disabled>Completar Depósito</button>
			</div>
		</div>
	</div>

	<!-- Modal Editar Usuario -->
	<div id="editBackdrop" class="modalBack" role="dialog" aria-modal="true" aria-labelledby="editTitle">
		<div class="modal" role="document" style="max-width:640px">
			<header>
				<h3 id="editTitle">Editar datos del JSON</h3>
				<button id="editClose" class="x" title="Cerrar" aria-label="Cerrar">×</button>
			</header>
			<div class="body">
				<form id="editForm" class="grid2" onsubmit="return false">
					<label>
						<div class="label">Nombre</div>
						<input class="inp" name="name" required />
					</label>
					<label>
						<div class="label">Email</div>
						<input class="inp" name="email" type="email" required />
					</label>

					<label>
						<div class="label">Moneda</div>
						<select class="inp" name="currency">
							<option value="HNL">HNL</option>
						</select>
					</label>
					<label>
						<div class="label">País</div>
						<select class="inp" name="country">
							<option value="HN">Honduras</option>
							<option value="US">USA</option>
						</select>
					</label>

					<label class="grow">
						<div class="label">Dirección</div>
						<input class="inp" name="address" />
					</label>
					<label>
						<div class="label">Ciudad</div>
						<input class="inp" name="city" />
					</label>

					<label>
						<div class="label">Departamento (state)</div>
						<select class="inp" name="state">
							<option value="AT">Atlántida</option>
							<option value="CH">Choluteca</option>
							<option value="CL">Colón</option>
							<option value="CM">Comayagua</option>
							<option value="CP">Copán</option>
							<option value="CR">Cortés</option>
							<option value="EP">El Paraíso</option>
							<option value="FM">Francisco Morazán</option>
							<option value="GD">Gracias a Dios</option>
							<option value="IN">Intibucá</option>
							<option value="LE">Lempira</option>
							<option value="LP">La Paz</option>
							<option value="OC">Ocotepeque</option>
							<option value="OL">Olancho</option>
							<option value="SB">Santa Bárbara</option>
							<option value="VA">Valle</option>
							<option value="YO">Yoro</option>
						</select>
					</label>
					<label>
						<div class="label">Teléfono</div>
						<input class="inp" name="phone" placeholder="+504 99999999" />
					</label>
				</form>
				<p class="hint" style="margin-top:8px">El teléfono se guardará sin espacios ni guiones. Ej: <code>+50431828143</code></p>
			</div>
			<div class="footer">
				<button id="editSave" class="btn btnPrimary">Guardar cambios</button>
			</div>
		</div>
	</div>

	<!-- Widget: servido desde tu Next.js -->
	<script src="<?= htmlspecialchars($CHECKOUT_SCRIPT) ?>"></script>
	<!-- SweetAlert2 -->
	<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

	<script src="codes.js"></script>
	<script>
		// ===== Utiles =====
		const statusEl = document.getElementById('status');
		const nf = new Intl.NumberFormat('es-HN');
		let lastAmountUsed = null;
		const CURRENCY = 'HNL';
		const MIN = 1; // ← coherente con tu hint
		const MAX = 12500;

		function formatMoney(n) {
			return `L ${nf.format(n)}`;
		}

		function getPixelMessageFromResult(result) {
			try {
				return (
					result?.pixel?.data?.response_reason ||
					result?.pixel?.response_reason ||
					result?.message ||
					result?.pixel_message ||
					"Resultado recibido"
				);
			} catch {
				return "Resultado recibido";
			}
		}

		function getPixelCodes(result) {
			try {
				const r = result?.pixel?.data || result?.pixel || {};
				return {
					code: r.response_code ?? null,
					approved: r.response_approved ?? null,
					reason: r.response_reason ?? null,
					uuid: r.payment_uuid ?? result?.payment_uuid ?? null,
					hash: r.payment_hash ?? result?.payment_hash ?? null,
				};
			} catch {
				return {};
			}
		}

		function setBusy(el, busy) {
			if (!el) return;
			if (busy) {
				el.setAttribute('aria-busy', 'true');
				el.disabled = true;
			} else {
				el.removeAttribute('aria-busy');
				el.disabled = false;
			}
		}

		// ===== Modal Depósito =====
		const bd = document.getElementById('depBackdrop');
		const btnOpen = document.getElementById('btn-deposito');
		const btnClose = document.getElementById('depClose');
		const btnBack = document.getElementById('depBack');
		const btnConfirm = document.getElementById('depConfirm');
		const promoRow = document.getElementById('promoRow');
		const chipOtro = document.getElementById('chipOtro');
		const inpMonto = document.getElementById('inpMonto');
		const totalLabel = document.getElementById('totalLabel');

		let lastFocused = null;

		function clearActiveChips() {
			promoRow.querySelectorAll('.chip').forEach(c => {
				c.classList.remove('active');
				c.setAttribute('aria-pressed', 'false');
			});
		}

		function setAmount(v) {
			const num = Number(String(v).replace(/[^\d.]/g, ''));
			const valid = Number.isFinite(num) && num >= MIN && num <= MAX;
			inpMonto.value = v === "" ? "" : (Number.isFinite(num) ? String(num) : "");
			totalLabel.textContent = formatMoney(Number.isFinite(num) ? num : 0);
			btnConfirm.disabled = !valid;
			inpMonto.setAttribute('aria-invalid', String(!valid && inpMonto.value !== ""));
			localStorage.setItem('bmt_last_amount', String(num || ''));
		}

		function openModal() {
			lastFocused = document.activeElement;
			bd.style.display = 'flex';
			document.body.style.overflow = 'hidden';
			const saved = localStorage.getItem('bmt_last_amount') || '';
			if (saved) {
				setAmount(saved);
			} else {
				setAmount("");
			}
			inpMonto.focus();
			// ESC para cerrar
			document.addEventListener('keydown', onEscClose);
		}

		function closeModal() {
			bd.style.display = 'none';
			document.body.style.overflow = '';
			clearActiveChips();
			setAmount("");
			document.removeEventListener('keydown', onEscClose);
			if (lastFocused && typeof lastFocused.focus === 'function') lastFocused.focus();
		}

		function onEscClose(e) {
			if (e.key === 'Escape') closeModal();
		}

		btnOpen.addEventListener('click', openModal);
		btnClose.addEventListener('click', closeModal);
		btnBack.addEventListener('click', closeModal);
		bd.addEventListener('click', (e) => {
			if (e.target === bd) closeModal();
		});

		promoRow.addEventListener('click', (e) => {
			const btn = e.target.closest('.chip');
			if (!btn) return;
			clearActiveChips();
			btn.classList.add('active');
			btn.setAttribute('aria-pressed', 'true');
			const v = btn.dataset.val || "";
			setAmount(v);
			if (!btn.dataset.val) inpMonto.focus(); // "Otro valor"
		});

		inpMonto.addEventListener('input', () => {
			clearActiveChips();
			setAmount(inpMonto.value);
		});
		// Enter para confirmar si válido
		inpMonto.addEventListener('keydown', (e) => {
			if (e.key === 'Enter' && !btnConfirm.disabled) btnConfirm.click();
		});

		// ===== Flujo: crear orden -> abrir widget -> confirmar =====
		btnConfirm.addEventListener('click', async () => {
			const amount = Number(inpMonto.value);
			if (!Number.isFinite(amount) || amount < MIN || amount > MAX) return;
			lastAmountUsed = amount;
			closeModal();
			statusEl.textContent = "Creando orden…";
			setBusy(btnOpen, true);

			try {
				const r = await fetch("crear-orden.php", {
					method: "POST",
					headers: {
						"Content-Type": "application/json"
					},
					body: JSON.stringify({
						amount: amount,
						currency: CURRENCY,
						description: "Recarga Hondubet"
					}),
					keepalive: true
				});
				const j = await r.json();
				if (!j?.success) throw new Error(j?.message || "No se pudo crear la orden");

				// Tolerancia: si API no devuelve checkout_url, construimos fallback con order_id
				const nextBase = <?= json_encode($NEXT_BASE) ?>;
				const checkoutUrl =
					j.checkout_url ||
					(j.order_id ? `${nextBase}/checkout/${encodeURIComponent(j.order_id)}?mode=sale&parent=${encodeURIComponent(location.origin)}` : null);

				if (!checkoutUrl) throw new Error("No se recibió checkout_url ni order_id");

				statusEl.textContent = "Abriendo formulario de pago…";

				if (typeof window.BMTCheckout !== 'object' || typeof window.BMTCheckout.open !== 'function') {
					throw new Error("BMTCheckout no está disponible (verifica que bmt-checkout.js cargó).");
				}

				window.BMTCheckout.open({
					checkoutUrl,
					onResult: async (result) => {
						console.log("[BMT] Resultado del widget:", result);
						const pixelMsg = getPixelMessageFromResult(result);
						const pixelCodes = getPixelCodes(result);

						statusEl.textContent = "Confirmando pago…";
						try {
							const r2 = await fetch("confirmar-orden.php", {
								method: "POST",
								headers: {
									"Content-Type": "application/json"
								},
								body: JSON.stringify({
									order_id: result.order_id,
									status: result.status, // <-- añade
									message: pixelMsg, // <-- añade
									pixel_codes: pixelCodes,
									payment_uuid: result.payment_uuid || pixelCodes.uuid || null,
									payment_hash: result.payment_hash || pixelCodes.hash || null
								}),
								keepalive: true
							});
							const j2 = await r2.json();
							console.log("[BMT] Respuesta confirmación:", j2);

							if (j2.success && j2.status === "PAID") {
								statusEl.textContent = "Pago acreditado ✅";
								Swal.fire({
									icon: "success",
									title: "Pago aprobado",
									html: `<div style="text-align:left">
      <p><b>Mensaje:</b> ${pixelMsg}</p>
      ${pixelCodes.code ? `<p><b>Código:</b> ${pixelCodes.code}</p>` : ""}
      ${result?.payment_uuid ? `<p><b>UUID:</b> ${result.payment_uuid}</p>` : ""}
    </div>`,
									confirmButtonText: "Continuar"
								});
							} else if (j2.success && j2.status === "PENDING") {
								const alertCfg = buildFrontMessage({
									pixelMsg,
									pixelCodes,
									result,
									amount: lastAmountUsed
								});
								statusEl.textContent = "Pago pendiente ⏳";
								Swal.fire({
									icon: "info",
									title: "Pago pendiente",
									html: alertCfg.html, // reaprovecha el detalle bonito
									confirmButtonText: "Ok"
								});
							} else {
								const alertCfg = buildFrontMessage({
									pixelMsg,
									pixelCodes,
									result,
									amount: lastAmountUsed
								});
								statusEl.textContent = j2.message || alertCfg.title || "Pago no aprobado ❌";
								Swal.fire({
									icon: alertCfg.icon || "error",
									title: alertCfg.title || "Pago no aprobado",
									html: alertCfg.html,
									confirmButtonText: "Entendido"
								});
							}
						} catch (e) {
							console.error(e);
							statusEl.textContent = "No se pudo confirmar el pago";
							Swal.fire({
								icon: "error",
								title: "Error al confirmar",
								text: String(e?.message || e)
							});
						} finally {
							setBusy(btnOpen, false);
						}
					}
				});

			} catch (err) {
				console.error(err);
				statusEl.textContent = String(err?.message || "No se pudo iniciar la recarga");
				setBusy(btnOpen, false);
			}
		});
	</script>

	<script>
		// ===== Modal Editar Usuario =====
		const editBtn = document.getElementById('editUserBtn');
		const editBd = document.getElementById('editBackdrop');
		const editClose = document.getElementById('editClose');
		const editForm = document.getElementById('editForm');
		const editSave = document.getElementById('editSave');

		function openEdit() {
			const phpUser = <?= json_encode($user, JSON_UNESCAPED_UNICODE) ?>;
			editForm.name.value = phpUser.name ?? '';
			editForm.email.value = phpUser.email ?? '';
			editForm.currency.value = phpUser.currency ?? 'HNL';
			const b = phpUser.billing ?? {};
			editForm.address.value = b.address ?? '';
			editForm.country.value = b.country ?? 'HN';
			editForm.state.value = b.state ?? '';
			editForm.city.value = b.city ?? '';
			editForm.phone.value = b.phone ?? '';
			editBd.style.display = 'flex';
			document.body.style.overflow = 'hidden';
			document.addEventListener('keydown', onEscEdit);
		}

		function closeEdit() {
			editBd.style.display = 'none';
			document.body.style.overflow = '';
			document.removeEventListener('keydown', onEscEdit);
			editBtn.focus();
		}

		function onEscEdit(e) {
			if (e.key === 'Escape') closeEdit();
		}

		editBtn.addEventListener('click', openEdit);
		editClose.addEventListener('click', closeEdit);
		editBd.addEventListener('click', (e) => {
			if (e.target === editBd) closeEdit();
		});

		editSave.addEventListener('click', async () => {
			const fd = new FormData(editForm);
			const payload = {
				name: String(fd.get('name') || ''),
				email: String(fd.get('email') || ''),
				currency: String(fd.get('currency') || 'HNL'),
				billing: {
					address: String(fd.get('address') || ''),
					country: String(fd.get('country') || 'HN').toUpperCase(),
					state: String(fd.get('state') || '').toUpperCase(),
					city: String(fd.get('city') || ''),
					phone: String(fd.get('phone') || '').replace(/[\s\-\.]/g, '')
				}
			};

			try {
				const r = await fetch('guardar-usuario.php', {
					method: 'POST',
					headers: {
						'Content-Type': 'application/json'
					},
					body: JSON.stringify(payload)
				});
				const j = await r.json();
				if (!j.success) throw new Error(j.message || 'No se pudo guardar');
				Swal.fire({
					icon: 'success',
					title: 'Guardado',
					timer: 1200,
					showConfirmButton: false
				});
				setTimeout(() => location.reload(), 900);
			} catch (err) {
				console.error(err);
				Swal.fire({
					icon: 'error',
					title: 'Error',
					text: String(err?.message || err)
				});
			}
		});
	</script>

</body>

</html>