<?php
/* public/confirmar-orden.php */

declare(strict_types=1);
require __DIR__ . '/config.php';
header('Content-Type: application/json; charset=utf-8');

try {
	// Acepta JSON y también form-data/x-www-form-urlencoded
	$raw = file_get_contents('php://input');
	$json = json_decode($raw, true);
	$src  = (is_array($json) && !empty($json)) ? $json : $_POST;

	$orderId     = (string)($src['order_id'] ?? '');
	$status      = (string)($src['status'] ?? ''); // opcional
	$paymentUuid = (string)($src['payment_uuid'] ?? '');
	$paymentHash = (string)($src['payment_hash'] ?? '');

	if ($orderId === '') throw new RuntimeException('order_id requerido');

	$payload = ['order_id' => $orderId];
	if ($status      !== '') $payload['status']       = $status;        // "APPROVED" | "DECLINED"
	if ($paymentUuid !== '') $payload['payment_uuid'] = $paymentUuid;
	if ($paymentHash !== '') $payload['payment_hash'] = $paymentHash;
	if (($src['message'] ?? '') !== '')     $payload['message'] = (string)$src['message'];
	if (isset($src['pixel_codes']))         $payload['pixel_codes'] = $src['pixel_codes'];
	$res = http_json_post(API_CONFIRM, $payload);

	if (!($res['success'] ?? false)) {
		http_response_code(400);
		echo json_encode([
			'success' => false,
			'message' => $res['message'] ?? 'No se pudo confirmar',
			'data' => $res
		], JSON_UNESCAPED_UNICODE);
		exit;
	}

	echo json_encode([
		'success' => true,
		'status'  => $res['status'] ?? null,
		'message' => $res['message'] ?? 'OK',
		'data'    => $res
	], JSON_UNESCAPED_UNICODE);
} catch (Throwable $e) {
	http_response_code(400);
	echo json_encode(['success' => false, 'message' => $e->getMessage()], JSON_UNESCAPED_UNICODE);
}
