// src/lib/pixel/codes.ts
export const PIXEL_ERRORS: Record<string, string> = {
  // Genéricos
  "01": "Transacción declinada por el emisor.",
  "02": "Banco emisor no disponible.",
  "03": "Comercio inválido o no configurado.",
  "05": "Transacción no aprobada.",
  "12": "Transacción inválida.",
  "13": "Monto inválido o fuera de rango.",
  "14": "Tarjeta inválida.",
  "15": "Emisor no encontrado.",
  "51": "Fondos insuficientes.",
  "54": "Tarjeta expirada.",
  "57": "Transacción no permitida.",
  "58": "Comercio no permite este tipo de operación.",
  "91": "Banco emisor no disponible.",
  "96": "Error general del sistema.",
  // Autenticación/llaves (texto libre del proveedor normalizado)
  "KEY_INVALID": "El valor de la KEY/HASH es inválido. Verifica tus credenciales.",
  "UNAUTHORIZED": "No autorizado: revisa X-API-Key / X-App-Key y Origin/Referer.",
};

// Casos de SANDBOX por monto (guía de QA)
export const SANDBOX_CASES: Record<number, { title: string; icon: 'success'|'error'|'warning' }> = {
  1:  { title: "Transacción Exitosa", icon: "success" },
  2:  { title: "Transacción Declinada", icon: "error" },
  3:  { title: "Configuración de comercio inválida", icon: "error" },
  4:  { title: "Tarjeta con reporte de robo o extravío", icon: "error" },
  5:  { title: "Error al encontrar cobro", icon: "error" },
  6:  { title: "Se superó el límite de intentos", icon: "error" },
  7:  { title: "Error general del sistema", icon: "error" },
  8:  { title: "Tiempo de espera excedido (timeout)", icon: "warning" },
  9:  { title: "Monto de transacción excedido", icon: "error" },
  10: { title: "Límite de transacciones excedido", icon: "error" },
  11: { title: "Límite por monto de transacciones excedido", icon: "error" },
  12: { title: "Límite por número de BIN", icon: "error" },
  13: { title: "Límite por tipo de tarjeta", icon: "error" },
  14: { title: "Límite por localización", icon: "error" },
};

// Dev flag (si quieres alternar sandbox/producción)
export function isSandbox(): boolean {
  try {
    if (typeof window !== 'undefined' && (window as any).BMT_ENV) {
      return (window as any).BMT_ENV === 'sandbox';
    }
    return (process.env.NEXT_PUBLIC_BMT_ENV || 'sandbox') === 'sandbox';
  } catch { return true; }
}
