export type Currency = 'HNL' | 'USD' | 'NIO';

export interface Customer { name: string; email: string; }
export interface Billing {
  address?: string; country: string; state?: string; city: string; phone?: string;
}

export interface InitInput {
  amount: number; currency: Currency; description: string;
  customer: Customer; billing: Billing;
}

export interface InitResponse {
  success: boolean; order_id: string; checkout_url: string;
}

export interface ConfirmInput {
  order_id: string; status?: 'APPROVED'|'DECLINED';
  payment_uuid?: string | null; payment_hash?: string | null; message?: string;
}
