import type { InitInput, InitResponse, ConfirmInput } from './types';

export async function initOrderClient(input: InitInput): Promise<InitResponse> {
  const r = await fetch('/api/bmt/init', {
    method: 'POST',
    headers: { 'Content-Type': 'application/json' },
    body: JSON.stringify(input),
  });
  if (!r.ok) throw new Error(`Init error (${r.status})`);
  return r.json();
}

export async function confirmOrderClient(input: ConfirmInput) {
  const r = await fetch('/api/bmt/confirm', {
    method: 'POST',
    headers: { 'Content-Type': 'application/json' },
    body: JSON.stringify(input),
  });
  if (!r.ok) throw new Error(`Confirm error (${r.status})`);
  return r.json();
}
