import type { Metadata } from "next";
import Script from "next/script";
import "./globals.css";

export const metadata: Metadata = {
  title: "Hondubet • Depósitos",
  description: "Flujo de recarga con BMT API",
};

export default function RootLayout({ children }: { children: React.ReactNode }) {
  return (
    <html lang="es">
      <head>
        {/* Widget del checkout que abre el modal */}
        {/* <Script src="http://127.0.0.1:3001/bmt-checkout.js" strategy="afterInteractive" /> */}
        {/* <Script src="http:///dev.bmticket.com/bmt-checkout.js" strategy="afterInteractive" /> */}
        <Script src="https://api.bmticket.com/bmt-checkout.js" strategy="afterInteractive" />
      </head>
      <body className="min-h-screen bg-slate-950 text-slate-100">
        <div className="container mx-auto p-6">{children}</div>
      </body>
    </html>
  );
}
