import { NextRequest, NextResponse } from "next/server";

export async function POST(req: NextRequest) {
	try {
		const body = await req.json();
		const base = process.env.BMT_BASE_URL!;
		const key = process.env.BMT_API_KEY!;
		const appKey = process.env.BMT_APP_KEY!; // usa la misma si no tienes otra
		const sendOrigin = process.env.BMT_ORIGIN!;    // Debe coincidir EXACTO con la allowlist

		const r = await fetch(`${base}/api/v1/checkout/init`, {
			method: "POST",
			headers: {
				"Content-Type": "application/json",
				"Accept": "application/json",
				"X-API-Key": key,
				"X-App-Key": appKey,
				"Origin": sendOrigin,   // <- exact match con allowlist del backend
				"Referer": sendOrigin,  // <- idem
			},
			body: JSON.stringify(body),
			cache: "no-store",
		});

		const data = await r.json();
		return NextResponse.json(data, { status: r.status });
	} catch (err: any) {
		return NextResponse.json({ success: false, message: err?.message || "Init failed" }, { status: 500 });
	}
}
