// hond-pay/src/app/api/bmt/confirm/route.ts
import { NextRequest, NextResponse } from "next/server";

export const runtime = "nodejs";

export async function POST(req: NextRequest) {
  try {
    const body = await req.json();

    const base = process.env.BMT_BASE_URL!;
    const key = process.env.BMT_API_KEY!;
    const appKey = process.env.BMT_APP_KEY ?? key;
    const fallbackOrigin = process.env.BMT_ORIGIN || "";

    if (!base) return NextResponse.json({ success:false, message:"Missing BMT_BASE_URL" }, { status:500 });
    if (!key)  return NextResponse.json({ success:false, message:"Missing BMT_API_KEY" }, { status:500 });

    const outgoingOrigin = req.headers.get("origin") || fallbackOrigin;

    // 👇 LOGS ANTES DEL FETCH (no exponen secretos)
    console.log("[confirm→BMT] url:", `${base}/api/v1/checkout/confirm`);
    console.log("[confirm→BMT] origin:", outgoingOrigin);
    console.log("[confirm→BMT] has keys:", { xApi: !!key, xApp: !!appKey });
    console.log("[confirm→BMT] body:", body);

    const r = await fetch(`${base}/api/v1/checkout/confirm`, {
      method: "POST",
      headers: {
        "content-type": "application/json",
        "accept": "application/json",
        "x-api-key": key,
        "x-app-key": appKey,
        "origin": outgoingOrigin,
        "referer": outgoingOrigin,
      },
      body: JSON.stringify(body),
      cache: "no-store",
    });

    // 👇 LOGS DESPUÉS DEL FETCH
    const text = await r.text(); // leemos texto para log; luego intentamos parsear
    console.log("[confirm←BMT] status:", r.status);
    console.log("[confirm←BMT] raw:", text);

    let data: any = {};
    try { data = text ? JSON.parse(text) : {}; } catch { data = { parseError: true, raw: text?.slice(0, 500) }; }

    // Si el backend te devuelve 401/403/4xx en body con 200 HTTP, lo verás aquí.
    return NextResponse.json(data, { status: r.status });
  } catch (err: any) {
    console.error("[confirm] error:", err);
    return NextResponse.json({ success:false, message: err?.message || "Confirm failed" }, { status:500 });
  }
}
